/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.impl;

import com.eeeab.eeeabsmobs.sever.entity.impl.EEEABMobEntity;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import org.apache.commons.lang3.ArrayUtils;

public abstract class EEEABMobLibrary
extends EEEABMobEntity
implements IAnimatedEntity,
IEntityAdditionalSpawnData {
    private int animationTick;
    private Animation animation = NO_ANIMATION;
    public boolean canplayHurtAnimation = true;
    public boolean hurtInterruptsAnimation = false;

    public EEEABMobLibrary(EntityType<? extends EEEABMobLibrary> type, Level level) {
        super(type, level);
    }

    public abstract Animation getDeathAnimation();

    public abstract Animation getHurtAnimation();

    public boolean m_6469_(DamageSource source, float damage) {
        boolean attack = super.m_6469_(source, damage);
        if (attack) {
            if (this.m_21223_() > 0.0f && (this.getAnimation() == NO_ANIMATION || this.hurtInterruptsAnimation) && this.canplayHurtAnimation) {
                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, this.getHurtAnimation());
            } else if (this.m_21223_() <= 0.0f) {
                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, this.getDeathAnimation());
            }
        }
        return attack;
    }

    @Override
    protected int getDeathDuration() {
        Animation death = this.getDeathAnimation();
        if (death != null) {
            return death.getDuration() - 20;
        }
        return 20;
    }

    public void playAnimation(Animation animation) {
        if (animation != null) {
            AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, animation);
        }
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public void setAnimation(Animation animation) {
        if (animation != NO_ANIMATION) {
            this.onAnimationStart(animation);
        } else {
            this.onAnimationFinish(this.animation);
        }
        this.animation = animation;
        this.setAnimationTick(0);
    }

    protected void onAnimationStart(Animation animation) {
    }

    protected void onAnimationFinish(Animation animation) {
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeInt(ArrayUtils.indexOf((Object[])this.getAnimations(), (Object)this.getAnimation()));
        buffer.writeInt(this.getAnimationTick());
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.f_19859_ = this.m_146908_();
        this.f_20883_ = this.f_20886_ = this.f_20885_;
        this.f_20884_ = this.f_20886_;
        int animOrdinal = additionalData.readInt();
        int animTick = additionalData.readInt();
        this.setAnimation(animOrdinal == -1 ? NO_ANIMATION : this.getAnimations()[animOrdinal]);
        this.setAnimationTick(animTick);
    }
}

